/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GContainer;
import acm.graphics.GObject;
import acm.util.ErrorException;
import java.util.Iterator;

class GIterator
implements Iterator {
    private GContainer cont;
    private int dir;
    private int index;
    private int nElements;

    public GIterator(GContainer gContainer, int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.dir = n;
                break;
            }
            default: {
                throw new ErrorException("Illegal direction for iterator");
            }
        }
        this.cont = gContainer;
        this.index = 0;
        this.nElements = gContainer.getElementCount();
    }

    public boolean hasNext() {
        return this.index < this.nElements;
    }

    public Object next() {
        if (this.dir == 1) {
            return this.cont.getElement(this.nElements - this.index++ - 1);
        }
        return this.cont.getElement(this.index++);
    }

    public GObject nextElement() {
        return (GObject)this.next();
    }

    public void remove() {
        if (this.dir == 1) {
            this.cont.remove(this.cont.getElement(this.nElements - --this.index - 1));
        } else {
            this.cont.remove(this.cont.getElement(--this.index));
        }
        --this.nElements;
    }
}

